import collections
import threading

class Queue:
    def __init__(self):
        self.ItemsQueue = collections.deque()
        self.ThreadCondition = threading.Condition(threading.Lock())

    def put(self, data):
        with self.ThreadCondition:
            if isinstance(data, (list, tuple)):
                self.ItemsQueue.extend(data)
            else:
                self.ItemsQueue.append(data)

            self.ThreadCondition.notify()

    def get(self):
        with self.ThreadCondition:
            while not self.ItemsQueue:
                self.ThreadCondition.wait()

            return self.ItemsQueue.popleft()

    def getall(self):
        with self.ThreadCondition:
            while not self.ItemsQueue:
                self.ThreadCondition.wait()

            items = list(self.ItemsQueue)
            self.ItemsQueue.clear()
            return items

    def clear(self):
        with self.ThreadCondition:
            self.ItemsQueue.clear()

    def isEmpty(self):
        with self.ThreadCondition:
            return not self.ItemsQueue
